package gov.va.genisis2.ts.dto;

import java.io.Serializable;

public class ConceptPredicateUriValueDTO implements Serializable, Comparable<ConceptPredicateUriValueDTO> {

	private static final long serialVersionUID = 5154446444925441586L;

	private String predicateUri;
	private String value;
	private Boolean isMvpPredicate;

	/**
	 * @return the predicateUri
	 */
	public String getPredicateUri() {
		return predicateUri;
	}

	/**
	 * @param predicateUri
	 *            the predicateUri to set
	 */
	public void setPredicateUri(String predicateUri) {
		this.predicateUri = predicateUri;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * @return the isMvpPredicate
	 */
	public Boolean getIsMvpPredicate() {
		return isMvpPredicate;
	}

	/**
	 * @param isMvpPredicate
	 *            the isMvpPredicate to set
	 */
	public void setIsMvpPredicate(Boolean isMvpPredicate) {
		this.isMvpPredicate = isMvpPredicate;
	}

	/**
	 * sort predicateUriValues on 'value' attribute
	 */
	public int compareTo(ConceptPredicateUriValueDTO predicateUriValue) {
		String localValue = (null != predicateUriValue) ? predicateUriValue.getValue() : null;
		return (null != localValue) ? this.value.compareToIgnoreCase(localValue) : -1;
	}
}
